#include <windows.h>
#include <ansi_c.h>
#include <utility.h>
#include <userint.h>
#include <cvirte.h>	
#include "Keithley_Pio_Test_Panel.h"

static int panelHandle;

int main (int argc, char *argv[])
{
	if (InitCVIRTE (0, argv, 0) == 0)
		return -1;	/* out of memory */
	if ((panelHandle = LoadPanel (0, "Keithley_Pio_Test_Panel.uir", PANEL)) < 0)
		return -1;
	DisplayPanel (panelHandle);
	RunUserInterface ();
	DiscardPanel (panelHandle);
	return 0;
}

int CVICALLBACK Hex (int panel, int event, void *callbackData,
		int eventData1, int eventData2)
{
	switch (event)
		{
		case EVENT_GOT_FOCUS:

			break;
		case EVENT_LOST_FOCUS:

			break;
		case EVENT_CLOSE:

			break;
		}
	return 0;
}

int CVICALLBACK Read (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{

	int portNumber=0x378;
	char byteRead;
	int loaded;
	
	switch (event)
		{
		case EVENT_COMMIT:
		
		// Check whether the LabWindows/CVI low-level support
		// Driver was loaded at startup
		loaded=CVILowLevelSupportDriverLoaded();
		
		
		//Read the port address form panel
		GetCtrlVal (panel, PANEL_PORTADDR, &portNumber);
		
		//Read from the parallel port
		byteRead =inp(portNumber);
		
		//Display to value to panel
		SetCtrlVal (panel, PANEL_BYTEVALUE, byteRead);
		

			break;
		}
	return 0;
}

int CVICALLBACK Write (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{

	int portNumber=0x378;
	int loaded;
	char byteWritten;
	char byteToWrite[20];
	
	switch (event)
		{
		case EVENT_COMMIT:
		
		// Check whether the LabWindows/CVI low-level support
		// Driver was loaded at startup
		loaded=CVILowLevelSupportDriverLoaded();         
		
		//Read the port address form panel  
		GetCtrlVal (panel,PANEL_PORTADDR, &portNumber);
		
		//Read value form to panel
		GetCtrlVal (panel,PANEL_BYTEVALUE,byteToWrite);
		
		//Write value to port
		byteWritten = outp(portNumber, byteToWrite[0]);
		
			break;
		}
	return 0;
}

int CVICALLBACK Exit (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event)
		{
		case EVENT_COMMIT:
		QuitUserInterface(0);
			break;
		}
	return 0;
}

int CVICALLBACK About (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event)
		{
		case EVENT_COMMIT:
		
		MessagePopup ("About PortIO CVI","Keithley Port I/O CVI Demo Version 1.0 \n\n Copyright 2001, Keithley \n\n E-mail: ustechsupport@keithley.com, Web: www.keithley.com");

			break;
		}
	return 0;
}
